package easik.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import easik.Easik;
import easik.EasikConstants;


/** 
 * Menu action for saving the sketch without first prompting for a file if possible.
 * 
 * @author Rob Fletcher 2005
 * @author Vera Ranieri 2006
 * @author Kevin Green 2006
 * @version 2006-08-03 Kevin Green
 */

public class FileSaveAction extends AbstractAction {
	
	/**
	 * Create a new action for saving the sketch or saving as if there is not
	 * already a file.
	 */
	public FileSaveAction() {
		super("Save Sketch");
		putValue(AbstractAction.MNEMONIC_KEY, new Integer(KeyEvent.VK_S));
		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Export current sketch as XML document");		
	}

	/**
	 * Check to see if the sketch already has a file name and if it doesn't prompt
	 * for one. Then save with that file name.
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e) {
			saveFile();
	}
	
	/**
	 * Static method to save file to allow for saves prompted by the user via the action listener
	 * or by the program via the export to SQL functions.
	 * 
	 * @since 2006-05-18 Vera Ranieri
	 */
	public static void saveFile(){
		
		File selFile;
		
		if (Easik.getInstance().getFrame().getSketch().getFile() == null ) {			
			JFileChooser saveDialog = new JFileChooser(Easik.getInstance().getIni().getDefaultFolder());
			saveDialog.setAcceptAllFileFilterUsed(false);
			saveDialog.setFileFilter( new XMLFileFilter() );
			saveDialog.showSaveDialog(Easik.getInstance().getFrame());
			selFile = saveDialog.getSelectedFile();
		} else {
			selFile = Easik.getInstance().getFrame().getSketch().getFile();
		}
		
		if (selFile != null) {	
			if(!selFile.getName().endsWith(EasikConstants.XML_FILE)){
				selFile = new File(selFile.getPath() + EasikConstants.XML_FILE);
			}
			Easik.getInstance().getFrame().getSketch().getDocInfo().setDateInfo();
			Easik.getInstance().getFrame().getSketch().saveToXML(selFile);
			Easik.getInstance().getFrame().getSketch().setFile(selFile);
			Easik.getInstance().getFrame().getSketch().setDirty(false);			
			Easik.getInstance().getIni().setLastUsedFolder(selFile.getAbsolutePath());
			Easik.getInstance().getIni().addRecentFile(selFile);
		}	
	}
}